/*
 Project: 	Custom Administration Package
 Data:   	21.October, 2002
 Author: 	Kevin Foote
 Description:	A Jabber component for customized administration
*/

/* Standard Include Stuff */
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

#include "include/CxmlFactory.h"
#include "include/CdataParser.h"
#include "include/sha1.h"


/* Local Constant Defs */
const unsigned JABBER_PORT=5999;
const unsigned MAXBUF=512;


/* Prototype Some Methods for our use later */
// This Method makes a socket connection
int makeConnect( int & /*socket*/ , sockaddr_in & /*server*/ );

// This Method starts a xml stream correctly
int startXMLstream( int & /*socket*/ );

// This Method handles ending a xml doc & connection with the server
void endXMLstream( int & /*socket*/ );

// This Method handles the rest of the socket comm.
void streamHandler( int & /*socket*/ );

// This Method handles a new xml chunk and converts it to our cmd
void dataHandler( char *, string & );

// This Method converts my SHA-1 key to a hex string to send out
string makeSHAhandshake( unsigned * );

// This Method creates xml chunk to send
string makeMessage( CdataParser &, string & );

// This Method will handle system requests arg1=command arg2=answer
int runCommand( string &, string & );



/* 
   The main driver of this application
   Arguments are not handled currently. 
 */
int main( int argc, char *argv[] )
{

	if(argc > 1) {
		//cout << "Usage: " << argv[0] << endl; //<< " [host]" << endl;
		cout << "No Help Docs Created Yet" << endl;
		return 1;
	}

	int _socket = 0;
	struct sockaddr_in _server;

	//
	// set up our socket very simply 
	//
	if( (makeConnect( _socket, _server )) != 0 ) {
		cerr << "ERROR creating Socket" << endl;
		return 1;
	}

	// ok..
	if( (startXMLstream( _socket )) != 0 ) {
		cerr << "ERROR Starting XML stream:stream" << endl;
		return 1;
	}

	// ok we'd better handel this new stream..
	streamHandler( _socket );

	// ok now we are done lets end our communication nicely
	endXMLstream( _socket );
	cout << "DONE" << endl;

	// ok we are done 
	return 0;
}


//
// This method creates the inital socket and connection to the 
// server. 
//
int makeConnect( int &_socket, sockaddr_in &_server )
{
	string _host = "127.0.0.1";   // we are only local
	int _my_connect = 0;
	struct hostent *host_entry = NULL;

	_socket = socket(AF_INET, SOCK_STREAM, 0);

	if(_socket < 0) {
		cerr << "Failed::Absolute socket init" << endl;
		return 1;
	}

	host_entry = gethostbyname( _host.c_str() );
	memcpy(&_server.sin_addr, host_entry->h_addr_list[0],
			host_entry->h_length);
	_server.sin_family = AF_INET;
	_server.sin_port = htons(JABBER_PORT);

	_my_connect = connect(_socket, (struct sockaddr *)&_server,
			sizeof(_server));

	if( _my_connect < 0 ) {
		cerr << "Failed::Absolute socket connect" << endl;
		return 1;
	}

	return 0;
}


//
// start a XML document (basicaly a stream that is unclosed)
// this function handles authentication as well
// this gets alittle sloppy towards the end.
//
int startXMLstream( int &_socket /*, sockaddr_in &_server*/ )
{
	int _x = 0;
	unsigned int _msg_digest[5];
	char * _buffy = new char[MAXBUF];
	string _msg;
	string _digest;
	string _incoming;
	string _id;
	string _pass = "secret";  // please don't hack me yet
	string _idpass;
	SHA1 _sha;

	// needs to be xml opener string 
	CxmlFactory _item;
	_item.setInitDoc(_msg);
	/*_item.getIt(_msg);*/

	if( (send( _socket, _msg.c_str(), _msg.length(), 0 )) > 0 ) {
		_x = recv( _socket, _buffy, MAXBUF, 0 );
	}
	else { return 1; }

	// this is for testing purposes .. 
	cout << "-->> " << _buffy << "\n";

	_incoming = (string) _buffy;

	// we want 8 characters after ..id='
	_id = _incoming.substr( 88, 8 );
	// combine to make our string to convert
	_idpass = _id + _pass;

	// using a borrowed SHA-1 object so lets just follow
	// its examples
	_sha.Reset();
	_sha << _idpass.c_str();

	if(!_sha.Result(_msg_digest)) {
		_x = 0;
		cerr << "ERROR -- creating message digest" << endl;
	} else {
		_digest = makeSHAhandshake( _msg_digest );
	}

	// testing purposes .. lets peak at our string
	cout << _digest << endl;

	// lets erase our message 
	_msg.erase();

	// now we can make and  send our handshake
	_item.Reset();
	_item.setHandshake( _digest, _msg );
	/*_item.getIt(_msg);*/

	_buffy = new char[MAXBUF];
	if( (send( _socket, _msg.c_str(), _msg.length(), 0 )) > 0 ) {
		_x = recv( _socket, _buffy, MAXBUF, 0 );
	}
	else { return 1; }

	// testing purposes .. lets peak at our string
	cout << endl << _buffy << endl;

	/*x = recv( _socket, _incoming.c_str(), _incoming.length(), 0 );*/

	if(_x <= 0) return 1;
	return 0;
}


//
// should handle loops of data in .. data out..
// we only want 512 bytes per packet
//
void streamHandler( int &_socket )
{
	string _str1;
	//string _str2;
	//string _from;
	char *_buffy = new char[MAXBUF];
	int _a = 0;	// probabably not the best way

	// if _a ever gets to be -1 or 0 terminate
	do {
		_str1.erase();
		_a = recv( _socket, _buffy, MAXBUF, 0 );

		cout << _buffy << endl << endl;

		// now lets handle our incomding xml &
		// create a message to send back..
		// _buffy = string from socket
		// _str1 = XML string to send back to socket
		dataHandler( _buffy, _str1 );

		// now lets make a new message to send
		//makeMessage( _str1, _from, _str2 );
		_a = send( _socket, _str1.c_str(), _str1.length(), 0 );

	} while( _a > 0 );

	return;
}


// 
// This closes the XML stream properly and hangs up the socket
// connection. Basicaly closes everything.
//
void endXMLstream( int &_socket )
{
	string _msg;

	CxmlFactory _item;
	_item.setEndDoc( _msg );
	/*_item.getIt( _msg );*/

	cout << "-->[ending]> " << _msg << endl;

	if( (send( _socket, _msg.c_str(), _msg.length(), 0 )) < 0 ) {
		cout << "Still connected!" << endl;
	}
	
	close( _socket );
	return;
}


// 
// This method will handle our data nicely. We will return a XML structure
// to send back to the socket, properly addressed and formated. 
// We will return this throught the second parameter _st
//
void dataHandler( char *buf, string &_st )
{
	//cout << "\nDOING SOME DATA STUFF\n";
	int _x;
	string _from;
	string _command;
	string _type;
	string _answer;
	CdataParser dat;
	
	dat.setMe( buf );
	dat.getType( _type );
	dat.getFrom( _from );
	dat.getData( _command );
	
	/* 
	we need to validate the _from field 
	then we need to enact the _msg item
	as a command (our perl stuff)
	*/

	//_x = validateFrom( _from );
	_x = runCommand( _command, _answer );
	_st = makeMessage( dat, _answer );
	return;
}


// 
// This method will make a xml message to send to server
// PARAMETERS: string _st => data to encapsulate
// RETURNED: string of XML data
// 
string makeMessage( CdataParser &dat, string &_st )
{
	string _str1;
	string _typ;
	string _to;
	CxmlFactory item;

	dat.getType( _typ );
	dat.getFrom( _to );

	item.setType( _typ );
	item.setTo( _to );
	item.setPayload( _st );
	item.getIt( _str1 );

	return _str1;
}


//
// This method converts my SHA-1 int values into a string of hex
// data. This will be send in a <handshake> tag..
// PARAMETERS: ptr to unsigned
// RETURNED: string
//
string makeSHAhandshake( unsigned * dat )
{
	string _x;

	// quick trick to make my unsigned int's into a string of hex
	for( int i = 0; i < 5; i++ ) {
		stringstream _ss;
		_ss << std::hex << dat[i];
		_x += _ss.str();
	}

	return _x;
}


// 
// This method runs the system command that is passed in.
// The resulting output from that command is returned 
// through the _answer parameter.
// PARAMETERS: string _cmd => command to execute
//             string _answer => result of command execution
// RETURNED: 0 for success 1 for fail
//
int runCommand( string &_cmd, string &_answer )
{
	string _ans;
	char _pbuffy[256];
	FILE *_pf;

	if( (_pf = popen( _cmd.c_str(), "r")) == NULL ) {
		return 1;
	}

	while( !feof( _pf ) ) {
		if( fgets( _pbuffy, 256, _pf ) != NULL )
			_ans += _pbuffy;
	}

	_answer = _ans;

	return 0;
}
