package mosaiccreator;

/**
 * <p>Title: Mosaic Image Creator </p>
 * <p>Description: recreats a mosaic image with a progress window</p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class MosaicImageCreater implements Runnable {

  private InteractiveViewer windowCameFrom;

  private double backgroundIntensity;

  /**
   *
   * @param windowCameFrom1 InteractiveViewer where the method return to
   * @param backgroundIntensity1 double the blending level
   */
  public MosaicImageCreater(InteractiveViewer windowCameFrom1,
                            double backgroundIntensity1) {

    this.windowCameFrom = windowCameFrom1;
    this.backgroundIntensity = backgroundIntensity1;

    //create a local thread
    Thread local = new Thread(this);
    local.setPriority(Thread.MIN_PRIORITY);
    local.start();

  }

  public void run() {


    MainWindow.currentMosaic.createMosaicPicture(backgroundIntensity,
                                                 windowCameFrom);
    //return to the class the called it
    this.windowCameFrom.creatingMosaicDone();
  }

}
