﻿using System.Drawing;
using GuitarTrainer.GuitarProComponents;

namespace GuitarTrainer.GUI
{
    /// <summary>
    /// Associates durations of beats or notes to a color
    /// </summary>
    class ColorScheme
    {
        private Color uniqueColor;

        private Color[] colors = 
        {
            Color.Cyan,  // Whole note
            Color.Blue,  // Half note
            Color.Black, // Quarter note
            Color.Red,   // Eighth note
            Color.Green, // 16th note
            Color.Olive, // 32nd note
            Color.Gold,  // 64th note
            Color.Yellow // 128th note
        };

        // Default constructor
        public ColorScheme()
        {
            uniqueColor = Color.Empty;
        }

        // Returns a clone of this color scheme
        public ColorScheme clone()
        {
            ColorScheme toReturn = new ColorScheme();

            if (isUniqueColor())
                toReturn.uniqueColor = uniqueColor;
            else
                toReturn.colors = (Color[])colors.Clone();

            return toReturn;
        }


        #region Getters and setters

        // Returns a color based on an index
        public Color getColor(int pos)
        {
            Color toReturn = Color.Empty;

            if ((pos >= 0) && (pos < colors.Length))
                toReturn = uniqueColor != Color.Empty ? uniqueColor : colors[pos];

            return toReturn;
        }

        // Returns the color of a particular duration (whole note, half note, etc)
        public Color getColor(GPDuration duration)
        {
            Color toReturn = Color.Empty;

            if (duration != null)
            {
                if (uniqueColor != Color.Empty)
                    toReturn = uniqueColor;
                else
                {
                    int pos = duration.getIndex();
                    if ((pos >= 0) && (pos < colors.Length))
                        toReturn = colors[pos];
                }
            }

            return toReturn;
        }

        private bool isUniqueColor()
        {
            return uniqueColor != Color.Empty;
        }

        #endregion
    }
}
