﻿using System;
using System.Windows.Forms;
using GuitarTrainer.Sound;

namespace GuitarTrainer.GUI
{
    /// <summary>
    /// Originally was going to base the music cursor scroller on events (like a full measure
    /// being played or something) but ran out of time. This class isn't really used but kept
    /// in because the project may head in that direction some day.
    /// </summary>
    class MusicCursorScroller : IPerformanceTimerListener
    {
        private readonly TrackPanel tp;
        private int prevMeasure;
        private readonly bool scroll;

        public MusicCursorScroller(TrackPanel tp, bool scrollTrack)
        {
            if (tp != null)
            {
                this.tp = tp;
                prevMeasure = -1;
                scroll = scrollTrack;
            }
            else
            {
                MessageBox.Show("TrackPanel passed is null (MusicCursorScroller.cs constructor");
                Environment.Exit(0);
            }
        }

        public void onTimer(PerformanceTimerEvent timerEvent)
        {
            if ((timerEvent.Beat != 1) || (timerEvent.Division != 1)) return;

            tp.setMusicCursor(timerEvent.Measure, prevMeasure, scroll);
            prevMeasure = timerEvent.Measure;
        }
    }
}
