﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes a point in a bend diagram
    /// </summary>
    class GPBendPoint
    {
        // Absolute time position, in sixtheenths of note duration
        // The bend height (100 per tone)
        // Determines how to play the section
        private readonly GPVibrato vibratoInstance;

        /// <summary>
        /// Creates a new bend point
        /// </summary>
        public GPBendPoint()
        {
            Position = 0;
            Value = 0;

            Vibrato = GPVibrato.none;
        }

        /// <summary>
        /// Returns the string representation of this bend point
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public string toString()
        {
            string toReturn = "Position: " + Position;
            toReturn += ", Height: " + Value;
            if (Vibrato != null)
                toReturn += ", Vibrato: " + Vibrato.ToString();

            return toReturn;
        }

        #region Getters and setters

        public int Position { private get; set; }

        public int Value { private get; set; }

        public GPVibrato Vibrato { private get; set; }

        #endregion
    }
}
