﻿namespace GuitarTrainer.GuitarProComponents
{
    // The class that describes a note belonging to a chord diagram
    class GPChordNote
    {
        // A chord note is represented by integer
        private readonly int type;

        // The chord notes this class supports
        public static readonly GPChordNote user = new GPChordNote(-1);
        public static readonly GPChordNote c = new GPChordNote(0);
        public static readonly GPChordNote cSharp = new GPChordNote(1);
        public static readonly GPChordNote d = new GPChordNote(2);
        public static readonly GPChordNote dSharp = new GPChordNote(3);
        public static readonly GPChordNote e = new GPChordNote(4);
        public static readonly GPChordNote f = new GPChordNote(5);
        public static readonly GPChordNote fSharp = new GPChordNote(6);
        public static readonly GPChordNote g = new GPChordNote(7);
        public static readonly GPChordNote gSharp = new GPChordNote(8);
        public static readonly GPChordNote a = new GPChordNote(9);
        public static readonly GPChordNote aSharp = new GPChordNote(10);
        public static readonly GPChordNote b = new GPChordNote(11);

        // The allowed chord notes
        private static readonly GPChordNote[] chordNotes = { user, c, cSharp, d, dSharp, e, f, fSharp, g, gSharp, a, aSharp, b };
        

        // The allowed chord note names
        private static readonly string[] chordNames = { "User", "C", "C#", "D", "D#", "E",
            "F", "F#", "G", "G#", "A", "A#", "B" };

        /// <summary>
        /// Creates a new chord note whose type is the parameter 'type'
        /// </summary>
        /// <param name="type">The type of chord note to be created</param>
        private GPChordNote(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the chord note associated with the value of the parameter 'value'
        /// </summary>
        /// <param name="value">The value of the chord note to find a reference of</param>
        /// <returns>The chord note that 'value' represents</returns>
        public static GPChordNote valueOf(int value)
        {
            if (value > 11)
                value = -1;
            return (chordNotes[value + 1]);
        }

        /// <summary>
        /// Returns the string representation of this chord note
        /// </summary>
        /// <returns>The name of this chord note</returns>
        public string toString()
        {
            return chordNames[type + 1];
        }
    }
}
