﻿namespace GuitarTrainer.GuitarProComponents
{
    // Class that describes tye type of chord (major, minor, 7M, etc)
    class GPChordType
    {
        // A chord type is represented by an integer
        private readonly int type;

        // All the chord types
        private static readonly GPChordType major = new GPChordType(0);
        private static readonly GPChordType seven = new GPChordType(1);
        private static readonly GPChordType sevenMajor = new GPChordType(2);
        private static readonly GPChordType six = new GPChordType(3);
        private static readonly GPChordType minor = new GPChordType(4);
        private static readonly GPChordType minorSeven = new GPChordType(5);
        private static readonly GPChordType minorSevenMajor = new GPChordType(6);
        private static readonly GPChordType minorSix = new GPChordType(7);
        private static readonly GPChordType sus2 = new GPChordType(8);
        private static readonly GPChordType sus4 = new GPChordType(9);
        private static readonly GPChordType sevenSus2 = new GPChordType(10);
        private static readonly GPChordType sevenSus4 = new GPChordType(11);
        private static readonly GPChordType diminished = new GPChordType(12);
        private static readonly GPChordType augmented = new GPChordType(13);
        private static readonly GPChordType fifth = new GPChordType(14);

        // The chord types
        private readonly static GPChordType[] chordTypes = { major, seven, sevenMajor, 
                 six, minor, minorSeven, minorSevenMajor, minorSix, sus2, 
                 sus4, sevenSus2, sevenSus4, diminished, augmented, fifth 
        };

        // The chord type names
        private readonly static string[] chordTypeNames = { "M", "7", "7M", "6", "m", "m7",
            "m7M", "m6", "sus2", "sus4", "7sus2", "7sus4", "dim", "aug", "5" };

        // Creates a new chord type whose type is the paramenter 'type'
        private GPChordType(int type)
        {
            this.type = type;
        }

        // Returns the chord type assocated with the value of the parameter 'type'
        public static GPChordType valueOf(int type)
        {
            return chordTypes[type];
        }

        // Returns a string representation of this chord diagram
        public string toString()
        {
            return chordTypeNames[type];
        }
    }
}
