﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes effects present on a particular beat
    /// 
    /// NOTE: CURRENTLY UNIMPLEMENTED
    /// </summary>
    class GPEffectsDuration
    {
        // Downstroke possibly assocated with this effect
        public GPDuration downStroke;

        // Presence of a fade-in
        public bool fadeIn;

        // Presence of a rasgueado
        public bool hasRasgueado;

        // Pickstroke possibly assocated with this effect
        public GPPickStroke pickStrokes;

        // Presence of a popping effect (bass guitar)
        public bool popping;

        // Presence of a slapping effect
        public bool slapping;

        // Presence of a tapping effect
        public bool tapping;

        // Tremolo bar possibly assocated with this effect
        public GPBend tremoloBar;

        // Upstroke possibly associated with this effect
        public GPDuration upStroke;

        // Create a new effects on beat
        public GPEffectsDuration()
        {
            downStroke = null;
            hasRasgueado = false;
            pickStrokes = null;
            popping = false;
            slapping = false;
            tapping = false;
            tremoloBar = null;
            upStroke = null;
        }

        // Returns a string representation of this effects on beat
        public string toString()
        {
            string toReturn = null;

            if (downStroke != null)
                toReturn = "downStroke" + ": " + downStroke.ToString();
            if (hasRasgueado)
                toReturn += ", hasRasgueado";
            if (pickStrokes != null)
                toReturn += ", pickStrokes" + ": " + pickStrokes.toString();
            if (popping)
                toReturn += ", popping";
            if (slapping)
                toReturn += ", slapping";
            if (tapping)
                toReturn += ", tapping";
            if (tremoloBar != null)
                toReturn += "tremoloBar" + ": " + tremoloBar.ToString();
            if (upStroke != null)
                toReturn += ", upStroke" + ": " + upStroke.ToString();

            return toReturn;
        }
    }
}
