﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes effects present on a note
    /// </summary>
    class GPEffectsOnNote
    {
        // Bend possibly associated with this effect
        public GPBend bend;

        // Grace note possibly associated with this effect
        public GPGraceNote graceNote;

        // Presence of a hammer-on or pull-off
        public bool hammerOnPullOff;

        // Harmonic possibly associated with this effect
        public GPHarmonic harmonic;

        // PResence of a left-hand vibrato
        public bool leftHandVibrato;

        // Presence of a let ring
        public bool letRing;

        // Presence of a palm-mute (PM)
        public bool palmMute;

        // Slide possibly associated with this effect
        public GPSlide slide;

        // Presence of staccato
        public bool staccato;

        // Tremolo picking possibly associated with this effect
        public GPDuration tremoloPicking;

        // Trill possibly associated with this effect
        public GPTrill trill;

        /// <summary>
        /// Creates a new effects on note
        /// </summary>
        public GPEffectsOnNote()
        {
            bend = null;
            graceNote = null;
            tremoloPicking = null;
            slide = null;
            harmonic = null;
            hammerOnPullOff = false;
            leftHandVibrato = false;
            letRing = false;
            palmMute = false;
            staccato = false;
            trill = null;
        }

        /// <summary>
        /// Returns a string representation of this effects on note
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public override string ToString()
        {
            string toReturn = "";

            if (graceNote != null)
                toReturn += "Grace Note: " + graceNote.toString();
            if (letRing)
                toReturn += "\nLet Ring: " + letRing;
            if (hammerOnPullOff)
                toReturn += "\nHammer-on or pull-off: " + hammerOnPullOff;
            if (bend != null)
                toReturn += "\nBend: " + bend;
            if (leftHandVibrato)
                toReturn += "\nLeft hand vibratto: " + leftHandVibrato;
            if (trill != null)
                toReturn += "\nTrill: " + trill.toString();
            if (harmonic != null)
                toReturn += "\nHarmonic: " + harmonic.ToString();
            if (slide != null)
                toReturn += "\nSlide: " + slide.ToString();
            if (tremoloPicking != null)
                toReturn += "\nTremolo picking: " + tremoloPicking;
            if (palmMute)
                toReturn += "\nPalm mute: " + palmMute;
            if (staccato)
                toReturn += "\nStaccato: " + staccato;

            return toReturn;
        }
    }
}
