﻿namespace GuitarTrainer.GuitarProComponents
{
    class GPKey
    {
        // The measure mode (major or minor)
        private readonly int mode;

        private readonly int type;

        // The keys this class accepts
        public static readonly GPKey cFlat;
        public static readonly GPKey gFlat;
        public static readonly GPKey dFlat;
        public static readonly GPKey aFlat;
        public static readonly GPKey eFlat;
        public static readonly GPKey bFlat;
        public static readonly GPKey f;
        public static readonly GPKey g;
        public static readonly GPKey c;
        public static readonly GPKey d;
        public static readonly GPKey a;
        public static readonly GPKey e;
        public static readonly GPKey b;
        public static readonly GPKey fSharp;
        public static readonly GPKey cSharp;
        public static readonly GPKey aFlatMinor;
        public static readonly GPKey eFlatMinor;
        public static readonly GPKey bFlatMinor;
        public static readonly GPKey fMinor;
        public static readonly GPKey cMinor;
        public static readonly GPKey gMinor;
        public static readonly GPKey dMinor;
        public static readonly GPKey aMinor;
        public static readonly GPKey eMinor;
        public static readonly GPKey bMinor;
        public static readonly GPKey fSharpMinor;
        public static readonly GPKey cSharpMinor;
        public static readonly GPKey gSharpMinor;
        public static readonly GPKey dSharpMinor;
        public static readonly GPKey aSharpMinor;

        // The keys
        private static readonly GPKey[,] keys = 
        {
            { cFlat, gFlat, dFlat, aFlat, eFlat, bFlat, f, c, g, d, a, e, b, fSharp, cSharp },
            { aFlatMinor, eFlatMinor, bFlatMinor, fMinor, cMinor, gMinor, dMinor, aMinor, 
              eMinor, bMinor, fSharpMinor, cSharpMinor, gSharpMinor, dSharpMinor, aSharpMinor }
        };

        // The keys' names
        private static string[,] keyNames =
        {
            { "C_FLAT", "G_FLAT", "D_FLAT", "A_FLAT", "E_FLAT", "B_FLAT", "F", "C", "G", "D",
                "A", "E", "B", "F_SHARP", "C_SHARP" },
            { "A_FLAT_MINOR", "E_FLAT_MINOR", "B_FLAT_MINOR", "F_MINOR", "C_MINOR", "G_MINOR",
                "D_MINOR", "A_MINOR", "E_MINOR", "B_MINOR", "F_SHARP_MINOR", "C_SHARP_MINOR",
                "G_SHARP_MINOR", "D_SHARP_MINOR", "A_SHARP_MINOR" }
        };

        /// <summary>
        /// Creates a new Key whose type is the paramter 'type'
        /// </summary>
        /// <param name="mode">Major or Minor</param>
        /// <param name="type">The key of the major or minor tone</param>
        private GPKey(int mode, int type)
        {
            this.mode = mode;
            this.type = type;
        }

        /// <summary>
        /// Returns a string representation of this Key
        /// </summary>
        /// <returns>The string representation of this</returns>
        public override string ToString()
        {
            return keyNames[mode,type + 7];
        }

        /// <summary>
        /// Returns the GPKey associated with the value index. (mode = Major)
        /// </summary>
        /// <param name="index">The index to look up a key for</param>
        /// <returns>The key that the index represents</returns>
        public static GPKey valueOf(int index)
        {
            return valueOf(0, index);
        }

        /// <summary>
        /// Returns the GPKey associated with the values mode and type
        /// </summary>
        /// <param name="mode">Major = 0, Minor = 1</param>
        /// <param name="type">The index to look up a key for</param>
        /// <returns>The key that the mode and index represent</returns>
        public static GPKey valueOf(int mode, int type)
        {
            return keys[mode,type + 7];
        }
    }
}