﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes a slide
    /// </summary>
    class GPSlide
    {
        // A slide is represented by an integer
        private readonly int type;
        
        // The types of slides this class accepts
        public static readonly GPSlide fromAbove = new GPSlide(-2);
        public static readonly GPSlide fromBelow = new GPSlide(-1);
        public static readonly GPSlide noSlide = new GPSlide(0);
        public static readonly GPSlide shiftSlide = new GPSlide(1);
        public static readonly GPSlide legatoSlide = new GPSlide(2);
        public static readonly GPSlide outDownward = new GPSlide(3);
        public static readonly GPSlide outUpward = new GPSlide(4);

        // The slides
        private static readonly GPSlide[] slides = { fromAbove, fromBelow, noSlide,
            shiftSlide, legatoSlide, outDownward, outUpward };

        // The slides' names
        private static readonly string[] slidesNames = { 
            "Slide into from above",
		    "Slide into from below",
		    "No slide",
		    "Shift slide",
		    "Legato slide",
		    "Slide out downwards",
		    "Slide out upwards"
        };

        /// <summary>
        /// Creates a new lide whose type is the parameter 'type'
        /// </summary>
        /// <param name="type">The index of the slide to set this object to</param>
        private GPSlide(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the slide associated with the value of the argument 'type'
        /// </summary>
        /// <param name="type">The index of the slide to look up</param>
        /// <returns>The slide the index represents</returns>
        public static GPSlide valueOf(int type)
        {
            return slides[type + 2];
        }

        /// <summary>
        /// Returns an index-like value starting from 0 for FROM_ABOVE
        /// </summary>
        /// <returns>The index fo the slide</returns>
        public int getIndex()
        {
            int toReturn;

            if (type < 0)
                toReturn = type + 2;
            else
                toReturn = type + 1;

            return toReturn;
        }

        /// <summary>
        /// Returns a string representation of this slide
        /// </summary>
        /// <returns>The string representation of this object</returns>
        public override string ToString()
        {
            return slidesNames[type + 2];
        }
    }
}
