﻿using System;
using System.Collections.Generic;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongPhraseListImpl : ISongPhraseList
    {
        private readonly List<ISongPhrase> phrases;

        public SongPhraseListImpl()
        {
            phrases = new List<ISongPhrase>();
        }

        public void addPhrase(ISongPhrase phrase)
        {
            phrases.Add(phrase);
        }

        public int getScoreMeasureCount()
        {
            int count = 0;
            foreach (ISongPhrase sp in phrases)
                count += sp.getScoreMeasureCount();

            return count;
        }

        public ISongMeasure getScoreMeasure(int measure)
        {
            int startMeasure = 0;
            foreach (ISongPhrase sp in phrases)
            {
                int measureCount = sp.getScoreMeasureCount();
                if ((measure >= startMeasure) && (measure < startMeasure + measureCount))
                    return sp.getScoreMeasure(measure - startMeasure);
                startMeasure += measureCount;
            }
            throw new IndexOutOfRangeException();
        }

        public int getPerformanceMeasureCount()
        {
            int count = 0;
            foreach (ISongPhrase sp in phrases)
                count += sp.getPerformanceMeasureCount();

            return count;
        }

        public ISongMeasure getPerformanceMeasure(int measure)
        {
            int startMeasure = 0;
            foreach (ISongPhrase sp in phrases)
            {
                int measureCount = sp.getPerformanceMeasureCount();
                if ((measure >= startMeasure) && (measure < startMeasure + measureCount))
                    return sp.getPerformanceMeasure(measure - startMeasure);
                startMeasure += measureCount;
            }
            throw new IndexOutOfRangeException();
        }

        public ISongPhrase getPhrase(int index)
        {
            return phrases[index];
        }

        public int PhraseCount
        {
            get { return phrases.Count; }
        }
    }
}
