﻿using System.Collections.Generic;

namespace GuitarTrainer.Interfaces
{
    /// <summary>
    /// A virtual track contains all the events on a specific slice of a parent ISongMeasureTrack.
    /// For example, the note events on a single guitar string are collated onto a single virtual track.
    /// </summary>
    interface ISongVirtualTrack
    {
        ISongMeasureTrack MeasureTrack
        {
            get;
        }

        int Index
        {
            get;
        }

        void addEvent(ISongEvent e);
        void addEvents(List<ISongEvent> events);
        List<ISongEvent> Events
        {
            get;
        }
    }
}
