﻿using System.Collections;
using System.Windows.Forms;

namespace GuitarTrainer.Interfaces
{
    static class TripletHash
    {
        private static readonly Hashtable tripletHash = createHash();

        private static Hashtable createHash()
        {
            Hashtable h = new Hashtable
                              {
                                  {1, new TripletValue(1, 1)},
                                  {3, new TripletValue(3, 2)},
                                  {5, new TripletValue(5, 4)},
                                  {6, new TripletValue(6, 4)},
                                  {7, new TripletValue(7, 4)},
                                  {9, new TripletValue(9, 8)},
                                  {10, new TripletValue(10, 8)},
                                  {11, new TripletValue(11, 8)},
                                  {12, new TripletValue(12, 8)},
                                  {13, new TripletValue(13, 8)}
                              };

            return h;
        }

        public static TripletValue getTriplet(int n)
        {
            TripletValue tv = (TripletValue)tripletHash[n];
            if (tv == null)
            {
                MessageBox.Show("Unexpected triplet value " + n + " found, go to non-triplet");
                return new TripletValue(1, 1);
            }
            return tv;
        }
    }
}
