# views.py
# This file implements view functions.
# 

from django.shortcuts import render_to_response

# RequestContext makes login inf avalible to templates
from django.template import RequestContext
from django.contrib.auth.models import User
from photosite.photoapp.models import PictureForm, Picture
from django.http import HttpResponseRedirect
from django.contrib.auth.decorators import login_required
from django.http import Http404


def handle_uploaded_file(user, form):
	new_picture = Picture(author=user)
	new_picture.name = form.cleaned_data['name']
	new_picture.keywords = form.cleaned_data['keywords']
	new_picture.rating = form.cleaned_data['rating']
	new_picture.rf = form.cleaned_data['rf']
	new_picture.rm = form.cleaned_data['rm']
	new_picture.main_pic = form.cleaned_data['main_pic']
	new_picture.thumbnail = form.cleaned_data['main_pic']
	new_picture.save()
	
def home_page(request):
	return render_to_response('home_page.html', context_instance=RequestContext(request))
	
def photographer(request, author_name):
	try:
		requested_name = User.objects.get(username = author_name)
	except User.DoesNotExist:
		raise Http404() # later change into page that mantions that the author is not in db		
	else:
		listOfPictures = Picture.objects.filter(author = requested_name)
		#for i in listOfPictures:
		#	print requested_name.first_name
		return render_to_response('photographer.html', locals(), context_instance=RequestContext(request))

@login_required(redirect_field_name='redirect_to')
def upload_file(request):
	if request.method == 'POST':
		form = PictureForm(request.POST, request.FILES)
		if form.is_valid():
			user = User.objects.get(username=request.user.username)
			handle_uploaded_file(user, form)
			return HttpResponseRedirect('/upload')
	else:
		form = PictureForm()
	
	return render_to_response('upload.html', {'form': form}, context_instance=RequestContext(request))

#############################################################################################################

